import pdfkit
import os
import jinja2
from random import getrandbits, randint
import sqlite3


import json
import pyodbc
import os

computer_name = os.environ['COMPUTERNAME']
server_name = computer_name
import datetime

# print(server_name)

# with open('test.json', 'r') as file:
#     data = json.load(file)

# with open('cache.txt','r+') as file:
#     state = file.read()
#     file.close()
# if state.lower() == 'c':
#     connection_str = "Driver={};SERVER={};PORT={};DATABASE={};uid={};pwd={};".format("{}{}{}".format('{',data['driver'],'}'),data['ip_address'],data['port'],data['db_name'],data['user'],data['pwd'])
# else:
#     connection_str = "Driver={};SERVER={}\\{};DATABASE={};user={};pwd={};".format("{}{}{}".format('{',data['driver'],'}'),data['ip_address'],data['port'],data['db_name'],data['user'],data['pwd'])



# connection_str = 'database.db'


with open('test.json', 'r') as file:
    data = json.load(file)

local_db = data['server_stat']
if local_db == "True":
    local_database = True
else:
    local_database = False
busines_name = "Hamza Traders"
if local_database:
    connection_str = 'database.db'
    query_string_first = "Null,"
    text_type = 'text'
    item_already_there_text = "IF NOT EXISTS"
    identity_text = ""
else:
    query_string_first = ""
    text_type = "VARCHAR(150)"
    item_already_there_text = ""
    identity_text = "IDENTITY(1,1)"
    with open('test.json', 'r') as file:
        data = json.load(file)

    with open('cache.txt','r+') as file:
        state = file.read()
        file.close()

    if data['computer_type'] == 'c':
        connection_str = "Driver={};SERVER={};PORT={};DATABASE={};uid={};pwd={};".format("{}{}{}".format('{',data['driver'],'}'),data['ip_address'],data['port'],data['db_name'],data['user'],data['pwd'])
    else:
        connection_str = "Driver={};SERVER={}\\{};DATABASE={};user={};pwd={};".format("{}{}{}".format('{',data['driver'],'}'),data['ip_address'],data['port'],data['db_name'],data['user'],data['pwd'])

def open_db():
    if local_database:
        con = sqlite3.connect(connection_str)
        cur = con.cursor()
    else:
        con = pyodbc.connect(connection_str)
        cur = con.cursor()        
    return  con, cur

def close_db(conection, commit=False):
    if commit:
        conection.commit()
    conection.close()


def rnd_val(x, digit=3):
    try:
        y = float(x)
    except:
        y = 0
    return round(y,digit)




























path_wkhtmltopdf = r'C:\Program Files\wkhtmltopdf\bin\wkhtmltopdf.exe'
config = pdfkit.configuration(wkhtmltopdf=path_wkhtmltopdf)
options = {
    'page-size': 'A4',
    'margin-top': '0.0in',
    'margin-right': '0.0in',
    'margin-bottom': '0.0in',
    'margin-left': '0.0in' }

con, cur = open_db()
record = cur.execute("SELECT * FROM product_details").fetchall()
close_db(con)

list_of_dict = []
data_dict = {}
sno = 0
for z in record:
    sno+=1
    data_dict["sno"] = sno
    data_dict["item_name"] = z[1].title()
    data_dict["rate"] = z[4]
    data_dict["qty"] = z[10]
    data_dict["total"] = rnd_val(rnd_val(z[4]) * rnd_val(z[10]))
    list_of_dict.append(data_dict)

env = jinja2.Environment(loader=jinja2.FileSystemLoader("."))
template = env.get_template("input.html")
html_out = template.render(navigation=list_of_dict,
                           title="",
                           message="")

with open("output.html", 'wb') as file_:
    file_.write(html_out.encode("utf-8"))

pdfkit.from_string(html_out, output_path="output.pdf", configuration=config,options = options)
os.startfile("output.pdf", "open")



# pdfkit.from_file("output.html", output_path="output.pdf", configuration=config, options=options)
# os.startfile("output.pdf", "open")